/*** EXAMPLE: Dirichlet L-function of a general character modulo odd p   ***/
/*** (illustration of functional equations with 2 different L-functions) ***/
/***                                                                     ***/
/*** v1.0, July 2002, questions to tim.dokchitser@durham.ac.uk           ***/
/*** type \rex-chgen or read("ex-chgen") at pari prompt to run this      ***/

default(realprecision,28);        \\ set working precision; used throughout

p = 37;                           \\ May change this to any odd prime

\\ Take the character defined by the following modulo p (has order p-1)
\\    (primitive root) -> e^(2 Pi I/(p-1))
\\ a(n) = if(n%p,exp(2*Pi*I/(p-1)*znlog(n,prim)),0);
\\ znlog needs pari 2.1, the following works with earlier versions

prim = znprimroot(p);
avec = vector(p,k,0);
for (k=0,p-1,avec[lift(prim^k)+1]=exp(2*Pi*I*k/(p-1)));
aaa = (n->avec[n%p+1]);
aaac = (n->conj(avec[n%p+1]));

                          \\ initialize L-function parameters
conductor = p;         \\ exponential factor
gammaV    = [1];       \\ [0] for even, [1] for odd
weight    = 1;        \\ L(s)=sgn*L(weight-s)
sgn       = X;        \\ unknown, to be solved from functional equation
initall([conductor,gammaV,weight,sgn]);initLdata(aaa,,aaac);

 \\ initialize L-series coefficients a(k)
 \\ and the ones of the dual motive

sgneq = Vec(checkfeq());       \\ checkfeq() returns c1+X*c2, should be 0
sgn   = -sgneq[2]/sgneq[1];    \\ hence solve for the sign
setsgn(sgn);

print("EXAMPLE: L(s)=L(Chi,s), Chi=character of order p-1 modulo p");
print("         with ",default(realprecision)," digits precision");
print("         take p=",p);
print("Chi(",lift(prim),")      = exp(2*Pi*I/",p-1,\
      ")    defines the character (mod ",p,")");
print("Parity      = ", if(getgammaV()[1],"odd","even"));
print("Sign          we will try to solve from the functional equation");
print("            = ", sgn);
print("|sign|      = ", abs(sgn));
print("Verifying functional equation. Error: ",errprint(checkfeq(1.1)));
print("L(Chi,2)    = ",L(2));
print("  (check)   = ",L(2,1.1));
print("L(Chi,I)    = ",L(I));
print("  (check)   = ",L(I,1.1));
